-- PCI Extreme.applescript
-- PCI Extreme

--  Created by Zack Schilling on Thu Aug 29 2002.
--  Copyright (c) 2002 Zack Schilling Software. All rights reserved.

on action theObject
	
	if title of theObject is "System Default" then
		tell window "main"
			set contents of text field "minVRAM" to 16
			set state of button "onAGP" to true
			set state of button "onPCI" to false
			set state of button "onPortable" to true
			set contents of text field "tileHeight" to 256
			set contents of text field "tileWidth" to 256
			set contents of text field "minDepth" to 16
		end tell
	end if
	
	if title of theObject is "PCI and AGP (Recommended)" then
		tell window "main"
			set contents of text field "minVRAM" to 16
			set state of button "onAGP" to true
			set state of button "onPCI" to true
			set state of button "onPortable" to true
			set contents of text field "tileHeight" to 256
			set contents of text field "tileWidth" to 256
			set contents of text field "minDepth" to 16
		end tell
	end if
	
	if title of theObject is "Old Portables (8MB Radeon)" then
		tell window "main"
			set contents of text field "minVRAM" to 8
			set state of button "onAGP" to true
			set state of button "onPCI" to false
			set state of button "onPortable" to true
			set contents of text field "tileHeight" to 256
			set contents of text field "tileWidth" to 256
			set contents of text field "minDepth" to 16
		end tell
	end if
	
	if title of theObject is "Off" then
		tell window "main"
			set contents of text field "minVRAM" to 16
			set state of button "onAGP" to false
			set state of button "onPCI" to false
			set state of button "onPortable" to false
			set contents of text field "tileHeight" to 256
			set contents of text field "tileWidth" to 256
			set contents of text field "minDepth" to 16
		end tell
	end if
	
	if title of theObject is "PCI Only" then
		tell window "main"
			set contents of text field "minVRAM" to 16
			set state of button "onAGP" to false
			set state of button "onPCI" to true
			set state of button "onPortable" to false
			set contents of text field "tileHeight" to 256
			set contents of text field "tileWidth" to 256
			set contents of text field "minDepth" to 16
		end tell
	end if
	
	if title of theObject is "AGP Only" then
		tell window "main"
			set contents of text field "minVRAM" to 16
			set state of button "onAGP" to true
			set state of button "onPCI" to false
			set state of button "onPortable" to false
			set contents of text field "tileHeight" to 256
			set contents of text field "tileWidth" to 256
			set contents of text field "minDepth" to 16
		end tell
	end if
	
	if title of theObject is "Portable Only" then
		tell window "main"
			set contents of text field "minVRAM" to 16
			set state of button "onAGP" to false
			set state of button "onPCI" to false
			set state of button "onPortable" to true
			set contents of text field "tileHeight" to 256
			set contents of text field "tileWidth" to 256
			set contents of text field "minDepth" to 16
		end tell
	end if
	
	if title of theObject is "- Add 256 Color Support" then
		tell window "main"
			set contents of text field "minDepth" to 8
		end tell
	end if
	
end action

on clicked theObject
	if name of theObject is "applyAndRestart" then
		
		set temp to display dialog "Are you sure you want to apply these changes and restart?" buttons {"Cancel", "Yes"} default button 2
		if button returned of temp = "Yes" then
			
			do shell script "cp -f /System/Library/Frameworks/ApplicationServices.framework/Versions/A/Frameworks/CoreGraphics.framework/Versions/A/Resources/Configuration.plist $home/Library/Preferences/"
			
			if (state of button "onAGP" of window "main") is 1 and (state of button "onPCI" of window "main") is 1 then
				set cardSupport to "IOAGPDevice, IOPCIDevice"
			end if
			
			if (state of button "onAGP" of window "main") is 1 and (state of button "onPCI" of window "main") is 0 then
				set cardSupport to "IOAGPDevice"
			end if
			
			if (state of button "onAGP" of window "main") is 0 and (state of button "onPCI" of window "main") is 1 then
				set cardSupport to "IOPCIDevice"
			end if
			
			if (state of button "onAGP" of window "main") is 0 and (state of button "onPCI" of window "main") is 0 then
				set cardSupport to " "
			end if
			
			set lineOne to "defaults write Configuration '{ GLCompositorConfiguration = { GLCompositorRequiredClasses = ( " & cardSupport & ") ; }; }'"
			
			if (state of button "onPortable" of window "main") is 1 then
				set onOff to "true"
			end if
			
			if (state of button "onPortable" of window "main") is 0 then
				set onOff to "false"
			end if
			
			set lineTwo to "defaults write Configuration GLCompositorConfiguration -dict-add GLCompositorMinimumDisplayDepth -integer " & (contents of text field "minDepth" of window "main")
			
			set lineThree to "defaults write Configuration GLCompositorConfiguration -dict-add GLCompositorMinimumVRAM -integer " & (contents of text field "minVRAM" of window "main")
			
			set lineFour to "defaults write Configuration GLCompositorConfiguration -dict-add GLCompositorUseOnPortable -boolean " & onOff
			
			set lineFive to "defaults write Configuration GLCompositorConfiguration -dict-add tileHeight -integer " & (contents of text field "tileHeight" of window "main")
			
			set lineSix to "defaults write Configuration GLCompositorConfiguration -dict-add tileWidth -integer " & (contents of text field "tileWidth" of window "main")
			
			do shell script lineOne
			do shell script lineTwo
			do shell script lineThree
			do shell script lineFour
			do shell script lineFive
			do shell script lineSix
			
			do shell script "sudo cp $home/Library/Preferences/Configuration.plist /System/Library/Frameworks/ApplicationServices.framework/Versions/A/Frameworks/CoreGraphics.framework/Versions/A/Resources/" with administrator privileges
			
			tell application "Terminal"
				do script with command "sudo cp $home/Library/Preferences/Configuration.plist /System/Library/Frameworks/ApplicationServices.framework/Versions/A/Frameworks/CoreGraphics.framework/Versions/A/Resources/"
			end tell
			
			tell application "Finder"
				display dialog "Click Restart after Terminal stops" buttons ("Restart") default button 1
				restart
			end tell
			
			quit
			
		end if
	end if
end clicked
on choose menu item theObject
	(*Add your script here.*)
end choose menu item
